﻿using Microscopic_Traffic_Simulator___Model.TrafficObjects;
using System;
using System.Windows;

namespace Microscopic_Traffic_Simulator___Model.GeometricObjects.Nodes
{
    /// <summary>
    /// Node on the beginning of the lane and can also contain generator.
    /// </summary>
    [Serializable]
    public class StartNode : Node
    {
        /// <summary>
        /// Generator connected to node.
        /// </summary>
        public Generator Generator { get; set; }

        /// <summary>
        /// Determines whether the node contains generator.
        /// </summary>
        public bool ContainsGenerator { get { return Generator != null; } }

        /// <summary>
        /// Constructs node on the beginning of the lane.
        /// </summary>
        /// <param name="location">Location of the node.</param>
        public StartNode(Point location) : base(location) { }
    }
}
